package gov.va.genisis2Test.daoImp;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;

import gov.va.genisis2.dao.impl.RequestDao;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class RequestDaoTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class RequestDaoTest.
 * 
 *          Description: In this RequestDaoTest Class which extends the abstract
 *          class, AbstractMockMvcTests, junit tests are defined.
 */

public class RequestDaoTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(RequestDaoTest.class);

	/**
	 * To test hibernate template.
	 */
	@Test
	public void TestGetTemplate() {
		// testing for Hibernate Template
		logger.info("**********Junit Test Get Template**********");

		RequestDao requestDao = new RequestDao();
		HibernateTemplate hibernateTemplate = requestDao.getHibernateTemplate();
		// for coverage
		Assert.assertNull(hibernateTemplate);
		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		hibernateTemplate = requestDao.getHibernateTemplate();
		Assert.assertNotNull(hibernateTemplate);

	}

	/**
	 * Test create request null.
	 */
	@Test
	public void TestCreateRequest_null() {
		// testing when request is null
		logger.info("**********Junit Test Create Request Null**********");

		Request request = new Request();
		getMockHibernateTemplate().save(request);
		int id = getMockRequestDao().createRequest(request);

	}

	/**
	 * To test create request.
	 */
	@Test
	public void TestCreateRequest_notNull() {
		// testing when request are not null
		logger.info("**********Junit Test Create Request Not Null**********");

		Request request = Helper.getNewRequest();
		getMockHibernateTemplate().save(request);

		int id = getMockRequestDao().createRequest(request);

	}

	/**
	 * Test get all requests.
	 */
	@Test
	public void TestGetAllRequests() {

		logger.info("**********Junit Test Get All Requests**********");

		RequestDao requestDao = new RequestDao();
		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		List<Request> requests = requestDao.getAllRequests();

	}

	/**
	 * Test get requests by id.
	 */
	@Test
	public void TestGetRequestsById() {

		logger.info("**********Junit Test Get Requests By Id**********");

		RequestDao requestDao = new RequestDao();
		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		Request request1 = requestDao.getRequestsById(1);
	}

	/**
	 * Test get all requests by comment history.
	 */
	@Test
	public void TestGetAllRequestsByCommentHistory() {

		logger.info("**********Junit Test Get All Requests By CommentHistory**********");

		Request request = Helper.getExistingRequest();
		getMockHibernateTemplate().save(request);

		CommentHistory commentHistory = new CommentHistory(1, request, null, "comments", new Date(), "createdBy",
				"taskId");
		commentHistory.setRequestId(1);
		getMockHibernateTemplate().save(commentHistory);

		List<Request> requests = getMockRequestDao().getAllRequestsByCommentHistory(1);
	}

	/**
	 * Test get all requests by staus.
	 */
	@Test
	public void TestGetAllRequestsByStaus() {

		logger.info("**********Junit Test Get All Requests By Staus**********");

		List<Request> requests = getMockRequestDao().getAllRequestsByStaus("Submitted");

	}

	/**
	 * Test get all requests by study approval.
	 */
	@Test
	public void TestGetAllRequestsByStudyApproval() {

		logger.info("**********Junit Test Get All Requests By StudyApproval**********");

		Request request = Helper.getExistingRequest();
		getMockHibernateTemplate().save(request);
		List<Request> requests = getMockRequestDao().getAllRequestsByStudyApproval(1);
	}

	/**
	 * Test get data sources.
	 */
	@Test
	public void TestGetDataSources() {

		logger.info("**********Junit Test Get Data Source**********");

		RequestDao requestDao = new RequestDao();
		requestDao.setHibernateTemplate(getMockHibernateTemplate());

		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		List<Source> dataSources = requestDao.getDataSources();
	}

	/**
	 * Test get request history by id.
	 */
	@Test
	public void TestGetRequestHistoryById() {

		logger.info("**********Junit Test Get Request History By Id**********");

		Request request = Helper.getExistingRequest();
		getMockHibernateTemplate().save(request);
		RequestHistory requestHistory = new RequestHistory(1, request, 1, "title", "description", "statusDescription", 1, 1, 1, new Date(), new Date(),
				"createdBy", "modifiedBy", "approverId", "taskId");
		getMockHibernateTemplate().save(requestHistory);

		List<RequestHistory> requestHistoryList = getMockRequestDao().getRequestHistoryById(1);

	}

	/**
	 * Test get requests by data manager.
	 */
	@Test
	public void TestGetRequestsByDataManager() {

		logger.info("**********Junit Test Get Requests By DataManager**********");

		List<Request> requests = getMockRequestDao().getRequestsByDataManager("testdatamanager");
	}

	/**
	 * Test get requests by UID.
	 */
	@Test
	public void TestGetRequestsByUID() {

		logger.info("**********Junit Test Get Requests By UID**********");

		List<Request> requests = getMockRequestDao().getRequestsByUID("testresearcher");
	}

	/**
	 * Test get requests data managers.
	 */
	@Test
	public void TestGetRequestsDataManagers() {

		logger.info("**********Junit Test Get Requests By DataManagers**********");

		List<Request> requests = getMockRequestDao().getRequestsDataManagers("datamanager1");
	}
	
	/**
	 * Test get requests data source managers.
	 */
	@Test
	public void TestGetRequestsDataSourceManagers() {

		logger.info("**********Junit Test Get Requests By DataSourceManagers**********");

		List<Request> requests = getMockRequestDao().getRequestsDataSourceManagers("datamanager1");
	}

	/**
	 * Test get request type.
	 */
	@Test
	public void TestGetRequestType() {

		logger.info("**********Junit Test Get Request Type**********");

		RequestDao requestDao = new RequestDao();
		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		RequestType requestType = requestDao.getRequestType(0);
	}

	/**
	 * Test get request types.
	 */
	@Test
	public void TestGetRequestTypes() {

		logger.info("**********Junit Test Get Request Types**********");

		RequestDao requestDao = new RequestDao();
		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		List<RequestType> requestTypes = requestDao.getRequestTypes();
	}

	/**
	 * Test get source.
	 */
	@Test
	public void TestGetSource() {

		logger.info("**********Junit Test Get Source**********");

		RequestDao requestDao = new RequestDao();
		requestDao.setHibernateTemplate(getMockHibernateTemplate());
		Source source = requestDao.getSource(0);
	}

	/**
	 * Test submit or modify.
	 */
	@Test
	public void TestSubmitOrModify() {

		logger.info("**********Junit Test Submit Or Modify**********");

		Request request = new Request();
		getMockHibernateTemplate().save(request);
		request.setDescription("modified description");
		int id1 = getMockRequestDao().submitOrModify(request);
	}

	/**
	 * Test submit or modify request history.
	 */
	@Test
	public void TestSubmitOrModifyRequestHistory() {

		logger.info("**********Junit Test Submit Or Modify RequestHistory**********");

		RequestHistory requestHistory = new RequestHistory();
		getMockHibernateTemplate().save(requestHistory);
		requestHistory.setDescription("modified description");
		int id1 = getMockRequestDao().submitOrModify(requestHistory);
	}

}
